/*
 * Decompiled with CFR 0.152.
 */
package components.input;

import components.input.ButtonInputProvider;
import components.input.MDJoypad3;

public class MDJoypad6
extends MDJoypad3 {
    private static final int[][] BUTTON_IDENTIFIERS = new int[][]{{32, 31, 30, 29, 12, 13}, {36, 35, 34, 33, 18, 19}};
    private static final int[] BUTTON_INDICES = new int[]{8, 9, 10, 11, 4, 5};
    private final int[] buttonIdentifiers;
    private int state;

    public MDJoypad6(int n, ButtonInputProvider buttonInputProvider) {
        this(n, buttonInputProvider, 0);
    }

    protected MDJoypad6(int n, ButtonInputProvider buttonInputProvider, int n2) {
        super(n, buttonInputProvider, 4 + n2);
        this.buttonIdentifiers = BUTTON_IDENTIFIERS[n & 1];
    }

    @Override
    public int readData(int n) {
        if (this.state == 2 && !this.isTHhigh()) {
            return super.readData(n) & 0x30;
        }
        if (this.state != 3) {
            return super.readData(n);
        }
        if (this.isTHhigh()) {
            int n2 = 192;
            int n3 = 0;
            while (n3 < this.buttonIdentifiers.length) {
                if (!this.isButtonDown(BUTTON_INDICES[n3])) {
                    n2 |= 1 << n3;
                }
                ++n3;
            }
            return n2;
        }
        return super.readData(n) | 0xF;
    }

    @Override
    public void frameFinished() {
        this.state = 0;
    }

    @Override
    protected void handleRisingEdgeTH(int n) {
        ++this.state;
    }

    @Override
    protected boolean isButtonPressed(int n) {
        int n2 = super.getButtonCount();
        if (n < n2) {
            return super.isButtonPressed(n);
        }
        return this.buttonInputProvider.isButtonDown(this.buttonIdentifiers[n -= n2]);
    }
}

